/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.ForDefinition;
import org.ow2.orchestra.facade.def.OnAlarmDefinition;
import org.ow2.orchestra.facade.def.UntilDefinition;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;


public class OnAlarmDefinitionImpl implements OnAlarmDefinition {

  private UntilDefinition untilDefinition;

  private ForDefinition forDefinition;

  private ActivityDefinitionUUID activityDefinitionUUID;

  public OnAlarmDefinitionImpl(final OnAlarmDefinition onAlarmDefinition) {
    this.activityDefinitionUUID = onAlarmDefinition.getActivityDefinitionUUID();
    this.untilDefinition = CopyUtil.copy(onAlarmDefinition.getUntilDefinition());
    this.forDefinition = CopyUtil.copy(onAlarmDefinition.getForDefinition());
  }

  public ActivityDefinitionUUID getActivityDefinitionUUID() {
    return activityDefinitionUUID;
  }

  public ForDefinition getForDefinition() {
    return forDefinition;
  }

  public UntilDefinition getUntilDefinition() {
    return untilDefinition;
  }

  public OnAlarmDefinition copy() {
    return new OnAlarmDefinitionImpl(this) ;
  }

}
