/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.def.impl;

import java.util.Date;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

/**
 *
 * @author Gael Lalire
 */
public class ProcessDefinitionImpl extends ScopeActivityDefinitionImpl implements ProcessDefinition {

  private static final long serialVersionUID = 35906774703995610L;

  protected String nameSpace;

  private final String expressionLanguage;
  private final String queryLanguage;

  private final Date deployedDate;
  private final Date undeployedDate;

  private final ProcessState state;

  public ProcessDefinitionImpl(final ProcessDefinition src) {
    super(src);
    this.enclosedActivityUUID = src.getEnclosedActivityUUID();
    this.nameSpace = src.getNameSpace();
    this.expressionLanguage = src.getExpressionLanguage();
    this.queryLanguage = src.getQueryLanguage();
    this.deployedDate = src.getDeployedDate();
    this.undeployedDate = src.getUndeployedDate();
    this.state = src.getState();
  }

  @Override
  public boolean equals(final Object obj) {
    if (obj == null) {
      return false;
    }
    if (!(obj.getClass().equals(this.getClass()))) {
      return false;
    }
    final ProcessDefinitionImpl other = (ProcessDefinitionImpl) obj;
    return other.getUUID().equals(this.getUUID());
  }

  @Override
  public ProcessDefinitionUUID getUUID() {
    return this.getProcessDefinitionUUID();
  }

  @Override
  public int hashCode() {
    return this.getUUID().hashCode();
  }

  /**
   * @return the enclosedActivityUUID
   */
  @Override
  public ActivityDefinitionUUID getEnclosedActivityUUID() {
    return this.enclosedActivityUUID;
  }

  /**
   * @param enclosedActivityUUID the enclosedActivityUUID to set
   */
  public void setEnclosedActivityUUID(final ActivityDefinitionUUID enclosedActivityUUID) {
    this.enclosedActivityUUID = enclosedActivityUUID;
  }

  public String getNameSpace() {
    return this.nameSpace;
  }

  public String getExpressionLanguage() {
    return this.expressionLanguage;
  }

  public String getQueryLanguage() {
    return this.queryLanguage;
  }

  public Date getDeployedDate() {
    return new Date(this.deployedDate.getTime());
  }

  public Date getUndeployedDate() {
    return new Date(this.undeployedDate.getTime());
  }

  @Override
  public ActivityType getType() {
    return ActivityType.PROCESS;
  }

  public QName getQName() {
    return new QName(this.getNameSpace(), this.getName());
  }

  public ProcessState getState() {
    return this.state;
  }
}
