/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.data.def;

import java.util.List;

import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;

/**
 *
 * @author Gael Lalire
 */
public class ScopeActivityDefinitionData extends ActivityDefinitionData {

  private final List<String> variablesName;

  public ScopeActivityDefinitionData(final ProcessDefinitionData processDefinitionData, final ActivityDefinitionUUID uuid,
    final ActivityDefinitionUUID encloserUUID, final String name, final List<String> variablesName) {
    super(processDefinitionData, uuid, encloserUUID, ActivityType.SCOPE, name);
    this.variablesName = variablesName;
  }

  protected ScopeActivityDefinitionData(final ProcessDefinitionData processDefinitionData, final ActivityDefinitionUUID uuid,
    final ActivityDefinitionUUID encloserUUID, final ActivityType activityType, final String name,
    final List<String> variablesName) {
    super(processDefinitionData, uuid, encloserUUID, activityType, name);
    this.variablesName = variablesName;
  }

  public List<String> getVariablesName() {
    return this.variablesName;
  }

}
