/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def;

import java.util.List;

import javax.xml.namespace.QName;

/**
 *
 * @author Alfonso Fuca
 */
public interface ReceiveActivityDefinition extends BpelActivityDefinition {

  /**
   *
   * @return the partner link
   */
  String getPartnerLink();
  /**
   *
   * @return the port type
   */
  QName getPortType();
  /**
   *
   * @return the operation
   */
  String getOperation();
  /**
   *
   * @return the value of createInstance attribute
   */
  boolean isCreateInstance();
  /**
   *
   * @return the message exchange
   */
  String getMessageExchange();
  /**
   *
   * @return the variable name
   */
  String getVariable();
  /**
  *
  * @return the list of correlation definitions
  */
  List<CorrelationDefinition> getCorrelationDefinitions();
  /**
  *
  * @return the list of correlation definitions
  */
  List<FromPartDefinition> getFromPartDefinitions();
}
