/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import org.ow2.orchestra.facade.def.CompletionConditionDefinition;

public class CompletionConditionDefinitionImpl implements CompletionConditionDefinition {

  private String expression;

  private String expressionLanguage;

  private boolean successfulBranchesOnly;

  public CompletionConditionDefinitionImpl(){
  }

  public CompletionConditionDefinitionImpl(final String expression, final String expressionLanguage, final boolean successfulBranchesOnly) {
    this.expression = expression;
    this.expressionLanguage = expressionLanguage;
    this.successfulBranchesOnly = successfulBranchesOnly;
  }

  public CompletionConditionDefinitionImpl(final CompletionConditionDefinition completionConditionDefinition) {
    this.expression = completionConditionDefinition.getExpression();
    this.expressionLanguage = completionConditionDefinition.getExpressionLanguage();
    this.successfulBranchesOnly = completionConditionDefinition.isSuccessfulBranchesOnly();
  }

  public String getExpression() {
    return expression;
  }

  public String getExpressionLanguage() {
    return expressionLanguage;
  }

  public boolean isSuccessfulBranchesOnly() {
    return successfulBranchesOnly;
  }

  public CompletionConditionDefinition copy() {
    return new CompletionConditionDefinitionImpl(this);
  }

}
