/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.def.ThrowActivityDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

/**
 * @author S. Ali Tokmen
 */
public class ThrowActivityDefinitionImpl extends BpelActivityDefinitionImpl implements ThrowActivityDefinition {

  private static final long serialVersionUID = 4300889445997344818L;

  private final QName faultName;

  private final String faultVariable;

  public ThrowActivityDefinitionImpl(final ThrowActivityDefinition activityDefinition) {
    super(activityDefinition);
    this.faultName = activityDefinition.getFaultName();
    this.faultVariable = activityDefinition.getFaultVariable();
  }

  public ActivityType getType() {
    return ActivityType.THROW;
  }

  public QName getFaultName() {
    return this.faultName;
  }

  public String getFaultVariable() {
    return this.faultVariable;
  }

}
