/**
 * Copyright (C) 2009  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.runtime;

import java.util.Map;

import org.ow2.orchestra.facade.CopyAble;
import org.w3c.dom.Element;

/**
 *
 * Variable to represent a WSDL message content.
 *
 * @author Guillaume Porcher
 *
 */
public interface Message  extends CopyAble<Message> {

  /**
   * @param partName
   * @return Element content of the message part 'partName'.
   */
  Element getPartValue(final String partName);

  /**
   * Test if the message has part named partName
   * (given in parameter).
   *
   * @param partName :
   *            name of the part.
   * @return true if the part has been found, false else.
   */
  boolean hasPart(final String partName);

  /**
   * @return a map with message part name as key and message part element as value.
   */
  Map<String, Element> getParts();

}