/**
 * Copyright (C) 2008-2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime;

import java.util.List;

import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;

/**
 * @author Alfonso Fuca, S. Ali Tokmen
 */
public interface ScopeActivityInstance extends ActivityWithSingleChildInstance {

  /**
   * Scope is a subtype of activity
   *
   * @return value of variables during
   */
  List<VariableUpdate> getVariables();

  List<CorrelationSetInitialization> getCorrelationSet();

  List<PartnerLinkUpdate> getPartnerLink();

  /**
   * List of scope state updates.
   *
   * @return List of scope state updates.
   */
  List<ScopeStateUpdate> getScopeState();

  /**
   * @return The fault handler activity that's been executed for this scope,
   *         null if no fault handler activity has been executed for this scope.
   */
  ActivityInstanceUUID getFaultHandlerActivityUUID();

  /**
   * @return The termination handler activity that's been executed for this
   *         scope, null if no termination handler activity has been executed
   *         for this scope.
   */
  ActivityInstanceUUID getTerminationHandlerActivityUUID();

  /**
   * @return The compensation handler activity that's been executed for this
   *         scope, null if no compensation handler activity has been executed
   *         for this scope.
   */
  ActivityInstanceUUID getCompensationHandlerActivityUUID();

  List<ActivityInstanceUUID> getEventInstanceUUIDs();

}
