/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import java.util.List;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.runtime.ProcessInstanceStateUpdate;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;

/**
 * Describes a process instance.
 * 
 * @author Alfonso Fuca, Guillaume Renault
 */
public class ProcessInstanceImpl extends ScopeActivityInstanceImpl implements ProcessInstance {

  private static final long serialVersionUID = -2012138860577256916L;

  /**
   * The list of state updates for this instance.
   */
  private List<ProcessInstanceStateUpdate> processInstanceState;

  public ProcessInstanceImpl(final ProcessInstance record) {
    super(record);
    this.processInstanceState = CopyUtil.copyList(record.getProcessInstanceStateUpdate());
  }

  @Override
  public ActivityType getType() {
    return ActivityType.PROCESS;
  }

  @Override
  public String toString() {
    String st = this.getClass().getName() + "[uuid: " + this.getUUID() + ", processDefinitionUUID: "
    + this.getProcessDefinitionUUID() + ", processUUID: " + this.getProcessInstanceUUID() + ", startedDate: "
    + this.getStartedDate() + ", endedDate: " + this.getEndedDate() + ", activityType: " + this.getType() + ", scopeState: "
    + this.getScopeState();
    st += "]\n";
    return st;
  }

  @Override
  public ProcessInstanceUUID getUUID() {
    return this.instanceUUID;
  }

  /**
   * @return the list of state updates for this instance.
   */
  public List<ProcessInstanceStateUpdate> getProcessInstanceStateUpdate() {
    return this.processInstanceState;
  }

  /**
   * Add a {@link ProcessInstanceStateUpdate} object in the list.
   */
  public void addProcessInstanceState(final ProcessInstanceStateUpdate state) {
    this.processInstanceState.add(state);
    this.activityState = state.getInstanceState();
  }

  /**
   * Returns the current instance state.
   * 
   * @return the current instance state.
   */
  public ActivityState getInstanceState() {
    return this.activityState;
  }

}
