/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import java.util.Date;

import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstanceStateUpdate;

/**
 * This object describes a state update of a process instance.
 *
 * @author Guillaume Renault
 */
public class ProcessInstanceStateUpdateImpl implements ProcessInstanceStateUpdate {

  /**
   *
   */
  private static final long serialVersionUID = 3785467428530417710L;

  /**
   * The date at which the update occured.
   */
  private final Date date;

  /**
   * The state of the update.
   */
  private final ActivityState state;

  /**
   *
   * @param record
   */
  public ProcessInstanceStateUpdateImpl(final ProcessInstanceStateUpdate record) {
    this.date = new Date(record.getDate().getTime());
    this.state = record.getInstanceState();
  }

  /**
   * @return the state of this update
   */
  public ActivityState getInstanceState() {
    return this.state;
  }

  /**
   * @return the date of this update.
   */
  public Date getDate() {
    return new Date(this.date.getTime());
  }

  /**
   * a copy of the update.
   */
  public ProcessInstanceStateUpdate copy() {
    return new ProcessInstanceStateUpdateImpl(this);
  }

  @Override
  public String toString() {
    return "Update process instance state at " + this.date + " to [" + this.getInstanceState() + "]";
  }

}
