/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.uuid;

import java.io.Serializable;

import org.ow2.orchestra.util.Misc;

/**
 * Abstract parent class for all UUID classes.
 * An uuid should be immutable.
 * So you do not need to make a copy of it.
 */
public abstract class AbstractUUID implements Serializable {

  private static final long serialVersionUID = -4314616158144530597L;

  public static final String SEPARATOR = "-";

  public static final String NUMBER_SEPARATOR = "$";

  protected String value;

  protected AbstractUUID() { }

  protected AbstractUUID(final AbstractUUID src) {
    Misc.checkArgsNotNull(src);
    this.value = src.getValue();
  }

  AbstractUUID(final String value) {
    Misc.checkArgsNotNull(value);
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }

  @Override
  public boolean equals(final Object obj) {
    if (obj == null) {
      return false;
    }
    if (!(obj.getClass().equals(this.getClass()))) {
      return false;
    }
    AbstractUUID other = (AbstractUUID)obj;
    if (other.value == null) {
      return value == null;
    }
    return other.value.equals(value);
  }

  @Override
  public int hashCode() {
    return value.hashCode();
  }

  protected String getValue() {
    return value;
  }
}
