/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.uuid;

import javax.xml.namespace.QName;

/**
 *
 * @author Gael Lalire
 */
public class ProcessDefinitionUUID extends ActivityDefinitionUUID {

  private static final long serialVersionUID = 5439202525374809781L;

  protected ProcessDefinitionUUID() {
    super();
  }

  public ProcessDefinitionUUID(final ProcessDefinitionUUID src) {
    super(src);
  }

  public ProcessDefinitionUUID(final QName name, final String uuid) {
    super(name.toString() + NUMBER_SEPARATOR + uuid);
  }

  public ProcessDefinitionUUID(final String processName, final String processNameSpace, final String uuid) {
    this(new QName(processNameSpace, processName), uuid);
  }

  public ProcessDefinitionUUID(final String value) {
    //this method is necessary to allow admin consoles to create a UUID from a string value
    super(value);
  }

}


