/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.util;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;

/**
 *
 * @author Charles Souillard
 * @author Guillaume Porcher
 */
public class StyleSheetRepository implements Serializable {


  private static final long serialVersionUID = -67804473770091529L;

  /**
   * Store all the styleSheet used in the process. key: String =>name of the
   * styleSheet value: StreamSource => the parsed styleSheet
   */
  protected Map<String, byte[]> styleSheets;

  /**
   * @return the styleSheets
   */
  public Map<String, byte[]> getStyleSheets() {
    return this.styleSheets;
  }


  /**
   * Add a new xslt styeSheet. The styleSheet is parsed and stored in the
   * styleSheet hashMap
   *
   * @param fileAddress :
   *            address of the new styleSheet.
   */
  public void addStyleSheet(final URL url, final String styleSheetSt) {
    if (this.styleSheets == null) {
      this.styleSheets = new HashMap<String, byte[]>();
    }
    try {
      final byte[] styleSheetBytes = Misc.getAllContentFrom(url);
      this.styleSheets.put(styleSheetSt, styleSheetBytes);
    } catch (final Exception e) {
      throw new OrchestraRuntimeException(
          "Problem when getting stylesheet from url : " + url, e);
    }
  }
}
