/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade;

import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;

/**
 * Manage a process instance.
 *
 * @author Guillaume Renault
 */
public interface InstanceManagementAPI {

  /**
   * Exit the given instance.
   *
   * @param processInstanceUUID
   *          the Id of the instance to exit.
   * @throws InstanceNotFoundException
   *           thrown if the given instance to exit is not found.
   */
  void exit(final ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException;

  /**
   * Resume a previously suspend instance of a process.
   *
   * @param processInstanceUUID
   *          the process instance UUID that identify the instance to resume.
   * @throws InstanceNotFoundException
   *           thrown if the given instance to resume is not found.
   */
  void resume(final ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException;

  /**
   * Suspend the given instance of a process.
   *
   * @param processInstanceUUID
   *          the process instance UUID that identify the instance to suspend.
   * @throws InstanceNotFoundException
   *           thrown if the given instance to suspend is not found.
   */
  void suspend(final ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException;
}
