/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.CorrelationDefinition;
import org.ow2.orchestra.facade.def.FromPartDefinition;
import org.ow2.orchestra.facade.def.OnMessageDefinition;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;


public class OnMessageDefinitionImpl implements OnMessageDefinition {

  private final String variable;

  private final QName portType;

  private final String partnerLink;

  private final String operation;

  private final String messageExchange;

  private final List<FromPartDefinition> fromPartList;

  private final List<CorrelationDefinition> correlationList;

  private final ActivityDefinitionUUID activityDefinitionUUID;

  public OnMessageDefinitionImpl(final OnMessageDefinition onMessageDefinition) {
    this.correlationList = CopyUtil.copyList(onMessageDefinition.getCorrelationDefinitionList());
    this.fromPartList = CopyUtil.copyList(onMessageDefinition.getFromPartDefinitionList());
    this.messageExchange = onMessageDefinition.getMessageExchange();
    this.operation = onMessageDefinition.getOperation();
    this.partnerLink = onMessageDefinition.getPartnerLink();
    this.portType = onMessageDefinition.getPortType();
    this.variable = onMessageDefinition.getVariable();
    this.activityDefinitionUUID = onMessageDefinition.getActivityDefinitionUUID();
  }

  public List<CorrelationDefinition> getCorrelationDefinitionList() {
    return this.correlationList;
  }

  public List<FromPartDefinition> getFromPartDefinitionList() {
    return this.fromPartList;
  }

  public String getMessageExchange() {
    return this.messageExchange;
  }

  public String getOperation() {
    return this.operation;
  }

  public String getPartnerLink() {
    return this.partnerLink;
  }

  public QName getPortType() {
    return this.portType;
  }

  public String getVariable() {
    return this.variable;
  }

  public OnMessageDefinition copy() {
    return new OnMessageDefinitionImpl(this);
  }

  public ActivityDefinitionUUID getActivityDefinitionUUID() {
    return this.activityDefinitionUUID;
  }

}
