/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
/**
 * Copyright (C) 2007  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.exception;

import javax.xml.namespace.QName;

/**
 * @author Juan Cantu
 * @author Guillaume Porcher
 */
public class BpelFaultException extends OrchestraRuntimeException {

  private static final long serialVersionUID = 1L;

  public static enum BpelFault {

    completionConditionFailure,
    conflictingReceive,
    conflictingRequest,
    invalidReply,
    invalidVariables,
    joinFailure,
    mismatchedAssignmentFailure,
    missingReply,
    missingRequest,
    repeatedCompensation,
    scopeInitializationFailure,
    selectionFailure,
    subLanguageExecutionFault,
    uninitializedPartnerRole,
    uninitializedVariable,
    unsupportedReference,
    invalidExpressionValue,
    invalidBranchCondition,
    correlationViolation,
    xsltStylesheetNotFound;

    public static final String XMLNS_BPEL_2_0_EXECUTABLE = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";

    public QName getQName() {
      return new QName(BpelFault.XMLNS_BPEL_2_0_EXECUTABLE, this.name());
    }
  }

  protected QName faultName;

  protected BpelFaultException() { }

  public BpelFaultException(final QName faultName) {
    this.faultName = faultName;
  }

  /**
   * @param message
   */
  public BpelFaultException(final QName faultName, final String message) {
    super(message);
    this.faultName = faultName;
  }

  /**
   * @param message
   * @param e
   */
  public BpelFaultException(final QName faultName, final String message, final Exception e) {
    super(message, e);
    this.faultName = faultName;
  }

  public static BpelFaultException generateBpelFaultException(final BpelFault fault) {
    if (fault != null) {
      return new BpelFaultException(fault.getQName());
    }

    return null;
  }

  public static BpelFaultException generateBpelFaultException(final BpelFault fault,
      final String message, final Exception cause) {
    if (fault != null) {
      return new BpelFaultException(fault.getQName(), message, cause);
    }

    return null;
  }

  public QName getFaultName() {
    return this.faultName;
  }

  public BpelFaultException copy() {
    return new BpelFaultException(this.getFaultName(), this.getMessage());
  }

  public BpelFaultException fullCopy() {
    return this.copy();
  }

  /* (non-Javadoc)
   * @see java.lang.Throwable#toString()
   */
  @Override
  public String toString() {
    return "BpelFaultException: " + this.getFaultName();
  }
}
