/**
 * Copyright (C) 2007  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.util;

import javax.xml.namespace.QName;

import com.ibm.wsdl.extensions.soap.SOAPConstants;
import com.ibm.wsdl.extensions.soap12.SOAP12Constants;

/**
 * bpel related namespace constants.
 */
public class XmlConstants {

  // xml namespaces
  /** xml ns. */
  public static final String XMLNS_XMLSCHEMA = "http://www.w3.org/2001/XMLSchema";

  /** xml ns. */
  public static final String XMLNS_XMLSCHEMAXSD = "http://www.w3.org/2001/xml.xsd";

  // wsdl namespaces
  /** wsdl ns. */
  public static final String XMLNS_WSDL = "http://schemas.xmlsoap.org/wsdl/";

  /** soap 1.1 ns. */
  public static final String XMLNS_WSDL11_SOAP11 = SOAPConstants.NS_URI_SOAP;

  /** soap 1.2 ns. */
  public static final String XMLNS_WSDL11_SOAP12 = SOAP12Constants.NS_URI_SOAP12;

  /** addressing 2004 ns. */
  public static final String ADDRESSING_2004_REF_NAMESPACE = "http://schemas.xmlsoap.org/ws/2004/08/addressing";

  /** addressing 2005 ns. */
  public static final String ADDRESSING_2005_REF_NAMESPACE = "http://www.w3.org/2005/08/addressing";

  /** addressing 2005 wsdl metadata ns. */
  public static final String ADDRESSING_2005_WSDL_NAMESPACE = "http://www.w3.org/2006/05/addressing/wsdl";
  // bpel namespaces
  /** bpel 2.0 executable ns. */
  public static final String XMLNS_BPEL_2_0_EXECUTABLE = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";

  /** bpel 2.0 absttract ns. */
  public static final String XMLNS_BPEL_2_0_ABSTRACT = "http://docs.oasis-open.org/wsbpel/2.0/process/abstract";

  /** bpel 2.0 partnerLinkType ns. */
  public static final String XMLNS_BPEL_2_0_PLNKTYPE = "http://docs.oasis-open.org/wsbpel/2.0/plnktype";

  /** bpel 2.0 varprop ns. */
  public static final String XMLNS_BPEL_2_0_VARPROP = "http://docs.oasis-open.org/wsbpel/2.0/varprop";

  /** bpel 2.0 serviceRef ns. */
  public static final String XMLNS_BPEL_2_0_SERVICEREF = "http://docs.oasis-open.org/wsbpel/2.0/serviceref";

  // varprop element/attributes names
  /** bpel 2.0 varprop schema - property element. */
  public static final String VARPROP_PROPERTY = "property";

  /** bpel 2.0 varprop schema - property element : name attribute. */
  public static final String VARPROP_PROPERTY_NAME = "name";

  /** bpel 2.0 varprop schema - property element : xmlType attribute. */
  public static final String VARPROP_PROPERTY_TYPE = "xmlType";

  /** bpel 2.0 varprop schema - property element : element attribute. */
  public static final String VARPROP_PROPERTY_ELEMENT = "element";

  /** bpel 2.0 varprop schema - propertyAlias element. */
  public static final String VARPROP_PROPERTYALIAS = "propertyAlias";

  /** bpel 2.0 varprop schema - propertyAlias element : propertyName attribute. */
  public static final String VARPROP_PROPERTYALIAS_PROPNAME = "propertyName";

  /** bpel 2.0 varprop schema - propertyAlias element : messageType attribute. */
  public static final String VARPROP_PROPERTYALIAS_MESSAGETYPE = "messageType";

  /** bpel 2.0 varprop schema - propertyAlias element : part attribute. */
  public static final String VARPROP_PROPERTYALIAS_PART = "part";

  /** bpel 2.0 varprop schema - propertyAlias element : xmlType attribute. */
  public static final String VARPROP_PROPERTYALIAS_TYPE = "xmlType";

  /** bpel 2.0 varprop schema - propertyAlias element : element attribute. */
  public static final String VARPROP_PROPERTYALIAS_ELEMENT = "element";

  /** bpel 2.0 varprop schema - query element. */
  public static final String VARPROP_PROPERTYALIAS_QUERY = "query";

  /** bpel 2.0 varprop schema - query element : queryLanguage attribute. */
  public static final String VARPROP_PROPERTYALIAS_QUERY_LANGUAGE = "queryLanguage";

  // service reference elements
  /** bpel 2.0 serviceRef schema - service-ref element. */
  public static final String SERVICE_REF_TAG_NAME = "service-ref";

  /** bpel 2.0 serviceRef schema - EndpointReference element. */
  public static final String EPR_TAG_NAME = "EndpointReference";

  /** bpel 2.0 serviceRef schema - Address element. */
  public static final String ADDRESS_TAG_NAME = "Address";

  /** bpel 2.0 serviceRef schema - ServiceName element. */
  public static final String SERVICE_NAME_TAG_NAME = "ServiceName";

  /** bpel 2.0 serviceRef schema - metadata element. */
  public static final String METADATA_TAG_NAME = "metadata";

  // simple Element default namespace and element name
  /** Default Element (when it is a simpleType E.g) prefix. */
  public static final String ELT_DEFAULT_PREFIX = "Orchestra_BPEL_Prefix";

  /** Default Element (when it is a simpleType E.g) ns. */
  public static final String ELT_DEFAULT_NS = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";

  /** Default Element (when it is a simpleType E.g) element name. */
  public static final String ELT_DEFAULT_ELEMENT = "ORCHESTRA_anonymous_element";

  /** prefix used for BPEL functions in xml document. E.g. getVariableProperty... */
  public static final String BPEL_FUNC_PREFIX = "bpel_func";

  /** orchestra ns for extensionActivties. */
  public static final String ORCHESTRA_NS = "http://orchestra.ow2.org";

  public static final QName FAULT_SELECTION_FAILURE = new QName(
      XmlConstants.XMLNS_BPEL_2_0_EXECUTABLE, "selectionFailure");

  public static final QName FAULT_SUB_LANGUAGE_EXECUTION = new QName(
      XmlConstants.XMLNS_BPEL_2_0_EXECUTABLE, "subLanguageExecutionFault");

  public static final String URN_XPATH_1_0 = "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0";

  public static final String NS_VENDOR = "urn:orchestra.org:bpel-2.0";

  public static final String NS_XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";

  public static final String ATTR_INITIALIZED = "initialized";

  public static final String ATTR_NIL = "nil";

  public static final String NS_XMLNS = "http://www.w3.org/2000/xmlns/";

  public static final String BPEL_DEFAULT_MESSAGE_EXCHANGE = "Orchestra default message exchange";

  public static final String BPEL_DEFAULT_ACTIVITY_NAME = "unnamed";
}
