/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.data.runtime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.XmlConstants;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 *
 * @author Gael Lalire
 */
public class CorrelationSetInitializedData extends ScopeUpdateData {

  private String name;

  private Map<QName, Node> propertyValues;

  public CorrelationSetInitializedData(final ActivityInstanceUUID scopeActivityUUID,
    final ActivityInstanceUUID activityInstanceUUID, final String name, final Map<QName, Node> propertyValues) {
    super(scopeActivityUUID, activityInstanceUUID);
    this.name = name;
    this.propertyValues = propertyValues;
  }

  /**
   * @return the name
   */
  public String getName() {
    return this.name;
  }

  /**
   * @return the propertyValues
   */
  public Map<QName, Node> getPropertyValues() {
    return this.propertyValues;
  }

  private void writeObject(final java.io.ObjectOutputStream out) throws IOException {
    out.writeObject(this.name);
    out.writeObject(this.propertyValues.size());
    for (final Entry<QName, Node> entry : this.propertyValues.entrySet()) {
      out.writeObject(entry.getKey().toString());
      final Node node = entry.getValue();
      final Element el = node.getOwnerDocument().createElementNS(
          XmlConstants.ELT_DEFAULT_NS,
          XmlConstants.ELT_DEFAULT_PREFIX + ":" + XmlConstants.ELT_DEFAULT_ELEMENT);
      el.appendChild(node);
      final ByteArrayOutputStream byteStream = XmlUtil.getNodeAsBAOS(el);
      out.writeObject(byteStream.toString());
    }
  }
  private void readObject(final java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
    this.name = (String) in.readObject();
    final int size = (Integer) in.readObject();
    this.propertyValues = new HashMap<QName, Node>(size);
    for (int i = 0; i < size; i++) {
      final QName key = QName.valueOf((String) in.readObject());
      final Node value = XmlUtil.getDocumentFromString((String) in.readObject()).getDocumentElement().getFirstChild();
      this.propertyValues.put(key, value);
    }
  }
}
