/**
 * Copyright (C) 2009  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.exception;

import javax.xml.namespace.QName;

import org.w3c.dom.Element;

/**
 * Represents a fault that has been thrown by the Bpel process with a variable
 * that doesn't correspond to any Element.
 */
public class FaultWithElement extends BpelFaultException {

  private static final long serialVersionUID = 5443993435906947404L;

  protected Element faultElement;

  // for persistence
  protected FaultWithElement() {
  }

  public FaultWithElement(final QName faultName, final Element faultElement) {
    super(faultName);
    if (faultElement != null) {
      this.faultElement = faultElement;
    }
  }

  public Element getFaultElement() {
    return this.faultElement;
  }

  @Override
  public String toString() {
    return "Fault " + this.faultName + (this.faultElement != null ? " (data: " + this.faultElement + ")." : ".");
  }

  @Override
  public FaultWithElement copy() {
    return new FaultWithElement(this.getFaultName(), this.getFaultElement());
  }
}
