/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.net.URL;
import javax.wsdl.Definition;
import org.ow2.orchestra.facade.wsdl.WsdlDefinitions;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.ProcessResourcesRepository;
import org.xml.sax.InputSource;

public class Deployment
implements Serializable {
    private static final long serialVersionUID = -5531271839683239304L;
    private byte[] bpel;
    private WsdlDefinitions wsdlDefinitions;
    private final ProcessResourcesRepository resourcesRepository = new ProcessResourcesRepository();

    public void addWsdlDefinition(String namespace, Definition wsdlDefinition) {
        if (this.wsdlDefinitions == null) {
            this.wsdlDefinitions = new WsdlDefinitions();
        }
        this.wsdlDefinitions.addWsdlDefinition(namespace, wsdlDefinition);
    }

    public void setBpelUrl(URL url) {
        Misc.checkArgsNotNull((Object[])new Object[]{url});
        try {
            this.bpel = Misc.getAllContentFrom((URL)url);
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't read bpel resource from url " + url, e);
        }
    }

    public InputSource getBpel() {
        return new InputSource(new ByteArrayInputStream(this.bpel));
    }

    public WsdlDefinitions getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    public ProcessResourcesRepository getResourcesRepository() {
        return this.resourcesRepository;
    }
}

