/**
 * Copyright (C) 2010  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.data.runtime;

import java.util.Date;

import org.ow2.orchestra.facade.data.AbstractData;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;


/**
 * @author Guillaume Porcher
 *
 */
public class JobData extends AbstractData {
  private final String jobType;
  private final long jobId;
  private final boolean isSuspended;
  private final Date dueDate;
  private final String exception;
  private final int retries;
  private final ActivityInstanceUUID activityInstanceUUID;
  private final ProcessInstanceUUID processInstanceUUID;


  public JobData(final String jobType,
      final long jobId,
      final boolean isSuspended,
      final Date dueDate,
      final String exception,
      final int retries,
      final ActivityInstanceUUID activityInstanceUUID,
      final ProcessInstanceUUID processInstanceUUID) {
    this.jobType = jobType;
    this.jobId = jobId;
    this.isSuspended = isSuspended;
    this.dueDate = dueDate;
    this.exception = exception;
    this.retries = retries;
    this.activityInstanceUUID = activityInstanceUUID;
    this.processInstanceUUID = processInstanceUUID;
  }


  /**
   * @return the jobType
   */
  public String getJobType() {
    return this.jobType;
  }

  public long getJobId() {
    return this.jobId;
  }

  public boolean isSuspended() {
    return this.isSuspended;
  }

  public Date getDueDate() {
    return this.dueDate;
  }

  public String getException() {
    return this.exception;
  }

  public int getRetries() {
    return this.retries;
  }

  public ActivityInstanceUUID getActivityInstanceUUID() {
    return this.activityInstanceUUID;
  }

  public ProcessInstanceUUID getProcessInstanceUUID() {
    return this.processInstanceUUID;
  }

}
