/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.data.runtime;

import java.io.IOException;

import org.ow2.orchestra.facade.runtime.Message;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Node;

/**
 *
 * @author Gael Lalire
 */
public class VariableUpdateData extends ScopeUpdateData {

  private String name;

  private Object value;

  public VariableUpdateData(final ActivityInstanceUUID scopeActivityUUID, final ActivityInstanceUUID activityUUID,
    final String name, final Object value) {
    super(scopeActivityUUID, activityUUID);
    this.name = name;
    this.value = value;
  }

  /**
   * @return the name
   */
  public String getName() {
    return this.name;
  }

  /**
   * @return the value
   */
  public Object getValue() {
    return this.value;
  }

  private void writeObject(final java.io.ObjectOutputStream out) throws IOException {
    out.writeObject(this.name);
    if (this.value instanceof Message) {
      out.writeBoolean(true);
      final Message message = (Message) this.value;
      out.writeObject(message);
    } else {
      out.writeBoolean(false);
      out.writeObject(XmlUtil.toString((Node) this.value));
    }

  }
  private void readObject(final java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
    this.name = (String) in.readObject();
    if (in.readBoolean()) {
      this.value = in.readObject();
    } else {
      this.value = XmlUtil.getDocumentFromString((String) in.readObject()).getDocumentElement();
    }

  }
}
