/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import org.ow2.orchestra.facade.def.ElseIfDefinition;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;

public class ElseIfDefinitionImpl implements ElseIfDefinition {

  private String expression;

  private String expressionLanguage;

  private ActivityDefinitionUUID activityDefinitionUUID;


  public ElseIfDefinitionImpl() {
  }

  public ElseIfDefinitionImpl(final String expression, final String expressionLanguage, final ActivityDefinitionUUID activityDefinitionUUID) {
    this.expression = expression;
    this.expressionLanguage = expressionLanguage;
    this.activityDefinitionUUID = activityDefinitionUUID;
  }

  public ElseIfDefinitionImpl(final ElseIfDefinition elseIfDefinition) {
    this.expression = elseIfDefinition.getExpression();
    this.expressionLanguage = elseIfDefinition.getExpressionLanguage();
    this.activityDefinitionUUID = elseIfDefinition.getActivityDefinitionUUID();
  }

  public String getExpression() {
    return expression;
  }

  public String getExpressionLanguage() {
    return expressionLanguage;
  }

  public ElseIfDefinition copy() {
    return new ElseIfDefinitionImpl(this);
  }

  public ActivityDefinitionUUID getActivityDefinitionUUID() {
    return activityDefinitionUUID;
  }

}
