/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import org.ow2.orchestra.facade.def.FromPartDefinition;

public class FromPartDefinitionImpl implements FromPartDefinition {

  private static final long serialVersionUID = 4944646222989721522L;

  private String part;

  private String toVariable;

  public FromPartDefinitionImpl() {
  }

  public FromPartDefinitionImpl(final FromPartDefinition fromPartDefinition) {
    this.part = fromPartDefinition.getPart();
    this.toVariable = fromPartDefinition.getToVariable();
  }

  public FromPartDefinitionImpl(final String part, final String toVariable) {
    this.part = part;
    this.toVariable = toVariable;
  }

  public String getPart() {
    return part;
  }

  public String getToVariable() {
    return toVariable;
  }

  public FromPartDefinition copy() {
    return new FromPartDefinitionImpl(this);
  }

}
