/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.runtime.impl;

import java.util.Date;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.RuntimeRecord;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.util.Misc;

public abstract class RuntimeRecordImpl
implements RuntimeRecord {
    private static final long serialVersionUID = -634690080367047966L;
    protected Date startedDate;
    protected Date endedDate;
    protected ProcessDefinitionUUID processUUID;
    protected ProcessInstanceUUID instanceUUID;
    protected ActivityState activityState;

    protected RuntimeRecordImpl(RuntimeRecord src) {
        Misc.checkArgsNotNull((Object[])new Object[]{src});
        this.processUUID = src.getProcessDefinitionUUID();
        this.instanceUUID = src.getProcessInstanceUUID();
        this.processUUID = src.getProcessDefinitionUUID();
        this.startedDate = new Date(src.getStartedDate().getTime());
        this.activityState = src.getState();
        if (src.getEndedDate() != null) {
            this.endedDate = src.getEndedDate();
        }
    }

    public ProcessDefinitionUUID getProcessDefinitionUUID() {
        return this.processUUID;
    }

    public ProcessInstanceUUID getProcessInstanceUUID() {
        return this.instanceUUID;
    }

    public Date getEndedDate() {
        if (this.endedDate == null) {
            return null;
        }
        return new Date(this.endedDate.getTime());
    }

    public Date getStartedDate() {
        return new Date(this.startedDate.getTime());
    }

    public void end(ActivityState finishState) {
        this.endedDate = new Date();
        this.activityState = finishState;
    }

    public int hashCode() {
        return this.processUUID.hashCode();
    }

    public ActivityState getState() {
        return this.activityState;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        RuntimeRecordImpl other = (RuntimeRecordImpl)obj;
        if (!this.getState().equals((Object)other.getState())) {
            return false;
        }
        if (!other.processUUID.equals(this.processUUID)) {
            return false;
        }
        return other.instanceUUID.equals(this.instanceUUID);
    }
}

