/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.def.PartnerLinkDefinition;

public class PartnerLinkDefinitionImpl implements PartnerLinkDefinition {

  private static final long serialVersionUID = 7928911106059762858L;

  private String myRole;
  private String name;
  private QName partnerLinkType;
  private String partnerRole;
  private boolean initializePartnerRole;


  public PartnerLinkDefinitionImpl() {
  }

  public PartnerLinkDefinitionImpl(final PartnerLinkDefinition partnerLinkDefinition) {
    this.myRole = partnerLinkDefinition.getMyRole();
    this.name = partnerLinkDefinition.getName();
    this.partnerLinkType = partnerLinkDefinition.getPartnerLinkType();
    this.partnerRole = partnerLinkDefinition.getPartnerRole();
    this.initializePartnerRole = partnerLinkDefinition.isInitializePartnerRole();
  }

  public PartnerLinkDefinitionImpl(final String myRole, final String name, final QName partnerLinkType,
    final String partnerRole, final boolean initializePartnerRole) {
    this.myRole = myRole;
    this.name = name;
    this.partnerLinkType = partnerLinkType;
    this.partnerRole = partnerRole;
    this.initializePartnerRole = initializePartnerRole;
  }

  public String getMyRole() {
    return myRole;
  }

  public String getName() {
    return name;
  }

  public QName getPartnerLinkType() {
    return partnerLinkType;
  }

  public String getPartnerRole() {
    return partnerRole;
  }

  public boolean isInitializePartnerRole() {
    return initializePartnerRole;
  }

  public PartnerLinkDefinition copy() {
    return new PartnerLinkDefinitionImpl(this);
  }

}
