/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import org.ow2.orchestra.facade.def.Source;

/**
 *
 * @author Gael Lalire
 */
public class SourceImpl implements Source {

  private static final long serialVersionUID = -2336155881613479724L;

  private String linkName;

  private String transitionConditionExpressionLanguage;

  private String transitionConditionBooleanExpression;

  public SourceImpl(final Source src) {
    linkName = src.getLinkName();
    transitionConditionBooleanExpression = src.getTransitionConditionBooleanExpression();
    transitionConditionExpressionLanguage = src.getTransitionConditionExpressionLanguage();
  }

  public String getLinkName() {
    return linkName;
  }

  public String getTransitionConditionBooleanExpression() {
    return transitionConditionBooleanExpression;
  }

  public String getTransitionConditionExpressionLanguage() {
    return transitionConditionExpressionLanguage;
  }

  public Source copy() {
    return new SourceImpl(this);
  }

}
