/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import java.util.Date;

import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.facade.runtime.ScopeStateUpdate;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;

/**
 * @author S. Ali Tokmen
 */
public class ScopeStateUpdateImpl implements ScopeStateUpdate {

  private static final long serialVersionUID = 2378213224435834157L;

  private final ActivityInstanceUUID activityUUID;

  private final Date date;

  private final ScopeState state;

  public ScopeStateUpdateImpl(final ScopeStateUpdate record) {
    this.activityUUID = record.getActivityUUID();
    this.date = new Date(record.getDate().getTime());
    this.state = record.getState();
  }

  public ActivityInstanceUUID getActivityUUID() {
    return this.activityUUID;
  }

  public Date getDate() {
    return new Date(this.date.getTime());
  }

  public ScopeState getState() {
    return this.state;
  }

  @Override
  public String toString() {
    return "Update scope state at " + this.date + " by " + this.activityUUID + " to [" + this.getState() + "]";
  }

  public ScopeStateUpdate copy() {
    return new ScopeStateUpdateImpl(this);
  }

}
