/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.wsdl.WsdlDefinitions;
import org.ow2.orchestra.util.ProcessResourcesRepository;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.util.wsdl.WsdlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeploymentUtil {
    private static final Logger LOG = Logger.getLogger(DeploymentUtil.class.getName());

    private DeploymentUtil() {
    }

    public static Deployment generateDeployment(URL bpelUrl, List<URL> wsdls) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Parsing BPEL from URL: " + bpelUrl + " using WSDL list: " + wsdls);
        }
        Deployment deployment = new Deployment();
        deployment.setBpelUrl(bpelUrl);
        WsdlDefinitions wsdlDefinitions = new WsdlDefinitions();
        if (wsdls != null) {
            for (URL wsdl : wsdls) {
                Definition wsdlDef = WsdlUtil.readWsdl((URL)wsdl);
                wsdlDefinitions.addWsdlDefinition(wsdlDef.getTargetNamespace(), wsdlDef);
            }
        }
        Document document = null;
        try {
            InputStream inStream = bpelUrl.openStream();
            document = XmlUtil.getDocumentFromInputStream((InputStream)inStream);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("couldn't parse xml document", e);
        }
        NodeList imports = document.getElementsByTagNameNS("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "import");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (int i = 0; i < imports.getLength(); ++i) {
            DeploymentUtil.parseImportElement((Element)imports.item(i), printWriter, bpelUrl, wsdlDefinitions, deployment);
        }
        printWriter.close();
        String errorMsg = stringWriter.getBuffer().toString();
        if (!"".equals(errorMsg)) {
            throw new OrchestraRuntimeException("errors during parsing of bpel imports: " + errorMsg);
        }
        for (String tagName : new String[]{"from", "to"}) {
            NodeList nodes = document.getElementsByTagNameNS("http://docs.oasis-open.org/wsbpel/2.0/process/executable", tagName);
            for (int i = 0; i < nodes.getLength(); ++i) {
                DeploymentUtil.parseStyleSheets((Element)nodes.item(i), printWriter, bpelUrl, deployment);
            }
        }
        return deployment;
    }

    private static void parseImportElement(Element importElement, PrintWriter printWriter, URL bpelURL, WsdlDefinitions definitions, Deployment deployment) {
        String namespace = null;
        if (importElement.hasAttribute("namespace")) {
            namespace = importElement.getAttribute("namespace");
        }
        String location = null;
        if (importElement.hasAttribute("location")) {
            location = importElement.getAttribute("location");
        }
        String importType = null;
        if (importElement.hasAttribute("importType")) {
            importType = importElement.getAttribute("importType");
        }
        if (importType == null) {
            printWriter.println("missing importType attribute in import element " + XmlUtil.toString((Node)importElement));
        } else if (importType.equals("http://schemas.xmlsoap.org/wsdl/")) {
            if (location != null) {
                URL wsdlURL = null;
                try {
                    URI bpelURI = new URI(bpelURL.toString().replace(" ", "%20"));
                    String bpelPath = bpelURL.toExternalForm();
                    if (location.startsWith("http://") || location.startsWith("https://") || location.startsWith("file:")) {
                        wsdlURL = new URL(location);
                    } else if (bpelURI.isOpaque() && bpelPath.startsWith("jar:")) {
                        int lastSlash = bpelPath.lastIndexOf("!") + 1;
                        String packageBase = bpelPath.substring(0, lastSlash);
                        String bpelBase = bpelPath.substring(lastSlash);
                        URI wsdlLocationInPackage = URI.create(bpelBase).resolve(location);
                        wsdlURL = new URL(packageBase + wsdlLocationInPackage);
                    } else {
                        wsdlURL = bpelURI.resolve(location).toURL();
                    }
                }
                catch (Exception e) {
                    throw new OrchestraRuntimeException("Exception while building wsdlURL : ", e);
                }
                Definition wsdlDefinition = WsdlUtil.readWsdl((URL)wsdlURL);
                deployment.addWsdlDefinition(namespace, wsdlDefinition);
            } else {
                Set<Definition> definitionsForNS = null;
                if (definitions != null) {
                    definitionsForNS = definitions.getWsdlDefinitions(namespace);
                }
                if (definitionsForNS == null) {
                    printWriter.println("No wsdl file to import in import element " + XmlUtil.toString((Node)importElement));
                } else {
                    for (Definition def : definitionsForNS) {
                        deployment.addWsdlDefinition(namespace, def);
                    }
                }
            }
        } else {
            printWriter.println("unsupported importType attribute in import element " + XmlUtil.toString((Node)importElement));
        }
    }

    private static void parseStyleSheets(Element item, PrintWriter printWriter, URL bpelUrl, Deployment deployment) {
        if (!XmlUtil.isTextOnly((Element)item)) {
            return;
        }
        String expression = XmlUtil.getContentText((Element)item);
        String functionNameBegin = "doXslTransform(";
        if (expression.contains("doXslTransform(")) {
            int indexBegin = expression.indexOf("doXslTransform(");
            int indexEnd = expression.indexOf(",", indexBegin + "doXslTransform(".length());
            String styleSheet = expression.substring(indexBegin + "doXslTransform(".length() + 1, indexEnd - 1);
            URL xslURL = null;
            try {
                if (styleSheet.startsWith("http://") || styleSheet.startsWith("file:")) {
                    xslURL = new URL(styleSheet);
                } else {
                    String bpelPath = bpelUrl.toExternalForm();
                    int lastSlash = bpelPath.lastIndexOf("/");
                    int lastBackSlash = bpelPath.lastIndexOf("\\");
                    String bpelBase = null;
                    bpelBase = lastSlash > lastBackSlash ? bpelPath.substring(0, lastSlash) : bpelPath.substring(0, lastBackSlash);
                    xslURL = new URL(bpelBase + "/" + styleSheet);
                }
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("Exception while building xslURL : ", e);
            }
            ProcessResourcesRepository resourceRepository = deployment.getResourcesRepository();
            resourceRepository.addResource(xslURL, styleSheet);
        }
    }
}

