/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.data.def;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.data.AbstractData;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

/**
 *
 * @author Gael Lalire
 */
public class ProcessDefinitionData extends AbstractData {

  private static final long serialVersionUID = 2576908685997000229L;

  private final ProcessDefinitionUUID uuid;

  private final String name;

  private final String nameSpace;

  public ProcessDefinitionData(final ProcessDefinitionUUID uuid, final String name, final String nameSpace) {
    this.uuid = uuid;
    this.name = name;
    this.nameSpace = nameSpace;
  }

  /**
   * @return the name
   */
  public String getName() {
    return this.name;
  }

  /**
   * @return the nameSpace
   */
  public String getNameSpace() {
    return this.nameSpace;
  }

  /**
   * @return the uuid
   */
  public ProcessDefinitionUUID getUUID() {
    return this.uuid;
  }

  /**
   * @return the qualified name of process
   */
  public QName getQName() {
    return new QName(this.nameSpace, this.name);
  }

}
