/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def;

import java.io.Serializable;
import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.CopyAble;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;


public interface OnMessageDefinition extends CopyAble<OnMessageDefinition>, Serializable {

  /**
   *
   * @return the partner link
   */
  String getPartnerLink();
  /**
   *
   * @return the operation
   */
  String getOperation();
  /**
   *
   * @return the variable
   */
  String getVariable();
  /**
   *
   * @return the message exchange
   */
  String getMessageExchange();
  /**
   *
   * @return the port type
   */
  QName getPortType();
  /**
   *
   * @return the list of correlations
   */
  List<CorrelationDefinition> getCorrelationDefinitionList();
  /**
   *
   * @return the list of from parts
   */
  List<FromPartDefinition> getFromPartDefinitionList();
  /**
   *
   * @return the UUID of the activity enclosed in the onMessage element
   */
  ActivityDefinitionUUID getActivityDefinitionUUID();

}
