/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import java.util.List;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.CopyDefinition;
import org.ow2.orchestra.facade.def.FromDefinition;
import org.ow2.orchestra.facade.def.ToDefinition;

public class CopyDefinitionImpl implements CopyDefinition {

  private static final long serialVersionUID = -6313088303704824547L;

  private List<FromDefinition> fromDefinitionList;

  private boolean keepSrcElementName;

  private List<ToDefinition> toDefinitionList;

  public CopyDefinitionImpl(final CopyDefinition copyDefinition) {
    this.keepSrcElementName = copyDefinition.isKeepSrcElementName();
    this.fromDefinitionList = CopyUtil.copyList(copyDefinition.getFromDefinitionList());
    this.toDefinitionList = CopyUtil.copyList(copyDefinition.getToDefinitionList());

  }

  public CopyDefinition copy() {
    return new CopyDefinitionImpl(this);
  }

  public List<FromDefinition> getFromDefinitionList() {
    return fromDefinitionList;
  }

  public boolean isKeepSrcElementName() {
    return keepSrcElementName;
  }

  public List<ToDefinition> getToDefinitionList() {
    return toDefinitionList;
  }
}
