/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import java.util.ArrayList;
import java.util.List;

import org.ow2.orchestra.facade.def.FlowActivityDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

/**
 *
 * @author Alfonso Fuca
 */
public class FlowActivityDefinitionImpl extends BpelActivityWithChildrenDefinitionImpl implements FlowActivityDefinition {

  private static final long serialVersionUID = -197814814273723848L;

  private final List<String> linkList = new ArrayList<String>();

  public FlowActivityDefinitionImpl(final FlowActivityDefinition record) {
    super(record);
    this.linkList.addAll(record.getLinks());
  }

  public ActivityType getType() {
    return ActivityType.FLOW;
  }

  public List<String> getLinks() {
    return this.linkList;
  }

}
