/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import org.ow2.orchestra.facade.def.ForDefinition;

public class ForDefinitionImpl implements ForDefinition {

  private static final long serialVersionUID = 5267113937223775083L;

  private String expressionLanguage;

  private String durationExpression;

  public ForDefinitionImpl() {
  }

  public ForDefinitionImpl(final String expressionLanguage, final String durationExpression) {
    this.expressionLanguage = expressionLanguage;
    this.durationExpression = durationExpression;
  }

  public ForDefinitionImpl(final ForDefinition forDefinition) {
    this.expressionLanguage = forDefinition.getExpressionLanguage();
    this.durationExpression = forDefinition.getDurationExpression();
  }

  public String getDurationExpression() {
    return this.durationExpression;
  }

  public String getExpressionLanguage() {
    return this.expressionLanguage;
  }

  public ForDefinition copy() {
    return new ForDefinitionImpl(this);
  }
}
