/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.def.VariableDefinition;

public class VariableDefinitionImpl implements VariableDefinition {

  private static final long serialVersionUID = 684346996027589377L;

  private QName element;
  private QName messageType;
  private String name;
  private QName type;


  public VariableDefinitionImpl() {
  }

  public VariableDefinitionImpl(final VariableDefinition variableDefinition) {
    this.element = variableDefinition.getElement();
    this.messageType = variableDefinition.getMessageType();
    this.name = variableDefinition.getName();
    this.type = variableDefinition.getType();
  }

  public VariableDefinitionImpl(final QName element, final QName messageType, final String name, final QName type) {
    this.element = element;
    this.messageType = messageType;
    this.name = name;
    this.type = type;
  }

  public QName getElement() {
    return element;
  }

  public QName getMessageType() {
    return messageType;
  }

  public String getName() {
    return name;
  }

  public QName getType() {
    return type;
  }

  public VariableDefinition copy() {
    return new VariableDefinitionImpl(this);
  }
}
