/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import java.util.ArrayList;
import java.util.List;

import org.ow2.orchestra.facade.runtime.ActivityWithChildrenInstance;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;


public abstract class ActivityWithChildrenInstanceImpl extends ActivityInstanceImpl implements ActivityWithChildrenInstance {

  private static final long serialVersionUID = -8308005565759631541L;

  protected List<ActivityInstanceUUID> enclosedActivitiesUUID;

  public ActivityWithChildrenInstanceImpl(final ActivityWithChildrenInstance record) {
    super(record);
    enclosedActivitiesUUID = new ArrayList<ActivityInstanceUUID>();
    enclosedActivitiesUUID.addAll(record.getEnclosedActivitiesUUID());
  }

  public List<ActivityInstanceUUID> getEnclosedActivitiesUUID() {
    return enclosedActivitiesUUID;
  }

}
