/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import java.util.List;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.FlowActivityInstance;
import org.ow2.orchestra.facade.runtime.TransitionConditionUpdate;

/**
 *
 * @author Gael Lalire
 */
public class FlowActivityInstanceImpl extends ActivityWithChildrenInstanceImpl implements FlowActivityInstance {

  private static final long serialVersionUID = -8696405119148398704L;

  /** list of links of the flow. */
  protected List<TransitionConditionUpdate> transitionConditionUpdateList;

  public FlowActivityInstanceImpl(final FlowActivityInstance record) {
    super(record);
    this.transitionConditionUpdateList = CopyUtil.copyList(record.getTransitionConditionUpdateList());
  }

  public ActivityType getType() {
    return ActivityType.FLOW;
  }

  public List<TransitionConditionUpdate> getTransitionConditionUpdateList() {
    return this.transitionConditionUpdateList;
  }


}
