/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import java.util.Date;

import org.ow2.orchestra.facade.runtime.WaitingActivity;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;

/**
 *
 * @author Gael Lalire
 */
public class WaitingActivityImpl implements WaitingActivity {

  private static final long serialVersionUID = -2397141557584450879L;

  private final ActivityDefinitionUUID activityDefinitionUUID;

  private final Date expectedStartedDate;

  public WaitingActivityImpl(final WaitingActivity waitingActivity) {
    this.activityDefinitionUUID = waitingActivity.getActivityDefinitionUUID();
    this.expectedStartedDate = new Date(waitingActivity.getExpectedStartedDate().getTime());
  }

  public ActivityDefinitionUUID getActivityDefinitionUUID() {
    return this.activityDefinitionUUID;
  }

  public Date getExpectedStartedDate() {
    return new Date(this.expectedStartedDate.getTime());
  }

  public WaitingActivity copy() {
    return new WaitingActivityImpl(this);
  }

}
