/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.data.runtime;

import org.ow2.orchestra.facade.data.AbstractData;
import org.ow2.orchestra.facade.data.def.ActivityDefinitionData;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;

/**
 * @author Gael Lalire
 */
public class ActivityInstanceData extends AbstractData {

  private static final long serialVersionUID = 523984561683349087L;

  private final ActivityDefinitionData activityDefinitionData;

  private final ProcessInstanceData processInstanceData;

  private final ActivityInstanceUUID uuid;

  private final ActivityInstanceUUID encloserUUID;

  public ActivityInstanceData(final ActivityDefinitionData activityDefinitionData,
      final ProcessInstanceData processInstanceData, final ActivityInstanceUUID uuid, final ActivityInstanceUUID encloserUUID) {
    this.activityDefinitionData = activityDefinitionData;
    this.processInstanceData = processInstanceData;
    this.uuid = uuid;
    this.encloserUUID = encloserUUID;
  }

  /**
   * @return the activityDefinitionData
   */
  public ActivityDefinitionData getActivityDefinitionData() {
    return this.activityDefinitionData;
  }

  /**
   * @return the processInstanceData
   */
  public ProcessInstanceData getProcessInstanceData() {
    return this.processInstanceData;
  }

  /**
   * @return the uuid
   */
  public ActivityInstanceUUID getUUID() {
    return this.uuid;
  }

  public ActivityInstanceUUID getEncloserUUID() {
    return this.encloserUUID;
  }

}
