/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import java.util.List;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.OnAlarmDefinition;
import org.ow2.orchestra.facade.def.OnMessageDefinition;
import org.ow2.orchestra.facade.def.PickActivityDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

/**
 *
 * @author Alfonso Fuca
 */
public class PickActivityDefinitionImpl extends BpelActivityDefinitionImpl implements PickActivityDefinition {

  private static final long serialVersionUID = 3268415930914443646L;

  private final boolean createInstance;

  private final List<OnMessageDefinition> onMessageDefinitionList;

  private final List<OnAlarmDefinition> onAlarmDefinitionList;

  public PickActivityDefinitionImpl(final PickActivityDefinition src) {
    super(src);
    this.createInstance = src.isCreateInstance();
    this.onMessageDefinitionList = CopyUtil.copyList(src.getOnMessageDefinitionList());
    this.onAlarmDefinitionList = CopyUtil.copyList(src.getOnAlarmDefinitionList());
  }

  public ActivityType getType() {
    return ActivityType.PICK;
  }

  public List<OnMessageDefinition> getOnMessageDefinitionList() {
    return this.onMessageDefinitionList;
  }

  public boolean isCreateInstance() {
    return this.createInstance;
  }

  public List<OnAlarmDefinition> getOnAlarmDefinitionList() {
    return this.onAlarmDefinitionList;
  }

}
