/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.def.CorrelationSetDefinition;

/**
 *
 * @author Alfonso Fuca
 */

public class CorrelationSetDefinitionImpl implements CorrelationSetDefinition {

  private static final long serialVersionUID = -3855182529873533020L;

  private String name;

  private List<QName> properties;

  public CorrelationSetDefinitionImpl() {
  }

  public CorrelationSetDefinitionImpl(final CorrelationSetDefinition correlationSetDefinition) {
    this.name = correlationSetDefinition.getName();
    this.properties = new ArrayList<QName>();
    if (correlationSetDefinition.getProperties() != null) {
      this.properties.addAll(correlationSetDefinition.getProperties());
    }
  }

  public CorrelationSetDefinitionImpl(final String name, final List<QName> properties) {
    this.name = name;
    this.properties = properties;
  }

  public String getName() {
    return name;
  }

  public CorrelationSetDefinition copy() {
    return new CorrelationSetDefinitionImpl(this);
  }

  public List<QName> getProperties() {
    return properties;
  }

}
