package org.ow2.orchestra.facade.criteria;

import java.io.Serializable;

/**
 * @author Loic Albertin
 */
public abstract class Field<T> implements Serializable {
  /**
   * For database queries this method returns a String that uniquely identifies
   * the stored SQL query.
   *
   * @return The stored SQL query ID.
   */
  public abstract String getStoredSqlId();

  @Override
  public final boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || this.getClass() != o.getClass()) {
      return false;
    }

    Field field = (Field) o;

    return (this.getStoredSqlId() != null ? this.getStoredSqlId().equals(field.getStoredSqlId()) : field.getStoredSqlId() ==
            null);

  }

  @Override
  public final int hashCode() {
    return this.getStoredSqlId() != null ? this.getStoredSqlId().hashCode() : 0;
  }
}
