/**
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * This class represents a page of {@link org.ow2.orchestra.facade.runtime.ProcessInstance}s corresponding to a
 * requested {@link org.ow2.orchestra.facade.criteria.Criteria}.
 *
 * @author Loic Albertin
 */
public class PagedResult<T> implements Serializable {

  /**
   * @see Serializable
   */
  private static final long serialVersionUID = -2881563733153669822L;

  /**
   * Returned set of {@link org.ow2.orchestra.facade.runtime.ProcessInstance}s for this page
   */
  private List<T> elements = new ArrayList<T>();

  /**
   * Total number of elements corresponding to requested {@link org.ow2.orchestra.facade.criteria.Criteria}
   * restrictions.
   */
  private long totalElementsCount = -1;

  public PagedResult() {
  }

  /**
   * @param elements           Returned set of {@link org.ow2.orchestra.facade.runtime.ProcessInstance}s for this page
   * @param totalElementsCount
   */
  public PagedResult(List<T> elements, int totalElementsCount) {
    this.elements = elements;
    this.totalElementsCount = totalElementsCount;
  }

  /**
   * @return Returns the set of {@link org.ow2.orchestra.facade.runtime.ProcessInstance}s for this page
   */
  public final List<T> getElements() {
    return elements;
  }

  /**
   * @return Returns the total number of elements corresponding to requested
   *         {@link org.ow2.orchestra.facade.criteria.Criteria} restrictions.
   */
  public final long getTotalElementsCount() {
    return totalElementsCount;
  }

  /**
   * @param totalElementsCount The totalElementsCount to set
   */
  public final void setTotalElementsCount(long totalElementsCount) {
    this.totalElementsCount = totalElementsCount;
  }

}
