package org.ow2.orchestra.facade.criteria;

import org.ow2.orchestra.facade.runtime.ProcessInstance;

/**
 * This class defines fields of process instances on which filtering is
 * supported
 *
 * @author Loic Albertin
 */
public class ProcessInstancesFiltersFields {

  /**
   * Utility classes should not have a public or default constructor.
   */
  private ProcessInstancesFiltersFields() {
  }

  /**
   * Defines a filter on a {@link org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID}
   */
  public static final FilterField<ProcessInstance> PROCESS_ID = new FilterField<ProcessInstance>() {

    public String getStoredSqlId() {
      return "ProcessId";
    }
  };

  /**
   * Defines a filter on a {@link org.ow2.orchestra.facade.runtime.ActivityState}
   */
  public static final FilterField<ProcessInstance> STATE = new FilterField<ProcessInstance>() {

    public String getStoredSqlId() {
      return "state";
    }
  };

  /**
   * Defines a filter on instance start date.<br/>
   * see {@link org.ow2.orchestra.facade.runtime.ProcessInstance#getStartedDate()}
   */
  public static final FilterField<ProcessInstance> START_DATE = new FilterField<ProcessInstance>() {

    public String getStoredSqlId() {
      return "startDate";
    }
  };

  /**
   * Defines a filter on the last instance update date.<br/>
   * see {@link org.ow2.orchestra.facade.runtime.ProcessInstanceStateUpdate#getDate()}
   */
  public static final FilterField<ProcessInstance> LAST_UPDATE_DATE = new FilterField<ProcessInstance>() {

    public String getStoredSqlId() {
      return "lastUpdateDate";
    }
  };
}
