/**
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.criteria;

import org.ow2.orchestra.facade.runtime.ProcessInstance;

/**
 * This class defines fields of process instances on which a sort is
 * supported
 *
 * @author Loic Albertin
 */
public class ProcessInstancesSortableFields {
  /**
   * Utility classes should not have a public or default constructor.
   */
  private ProcessInstancesSortableFields() {
  }

  /**
   * Defines a sort on a ({@link org.ow2.orchestra.facade.def.ProcessState})
   */
  public static final SortableField<ProcessInstance> STATE = new SortableField<ProcessInstance>() {
    public String getStoredSqlId() {
      return "ActivityState";
    }
  };

  /**
   * Defines a sort on a instance start date
   */
  public static final SortableField<ProcessInstance> START_DATE = new SortableField<ProcessInstance>() {
    public String getStoredSqlId() {
      return "StartedDate";
    }
  };

  /**
   * Defines a sort on a instance last update date
   */
  public static final SortableField<ProcessInstance> LAST_UPDATE_DATE = new SortableField<ProcessInstance>() {
    public String getStoredSqlId() {
      return "LastUpdate";
    }
  };
}
