/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def;

import java.io.Serializable;

import javax.xml.namespace.QName;

/**
 *
 * @author Alfonso Fuca
 */
public interface FromToDefinition extends Serializable {

  /**
   *
   * @return the expression language
   */
  String getExpressionLanguage();
  /**
   *
   * @return the part name
   */
  String getPart();
  /**
   *
   * @return the partner link name
   */
  String getPartnerLink();
  /**
   *
   * @return the property
   */
  QName getProperty();
  /**
   *
   * @return the variable
   */
  String getVariable();
  /**
   *
   * @return the endpoint reference
   */
  String getEndpointReference();
  /**
   *
   * @return the variant (enum)
   */
  Variant getVariant();
  /**
   *
   * @return the expression
   */
  String getExpression();
  /**
   *
   * @return the query language
   */
  String getQueryLanguage();
  /**
   *
   * @return the query
   */
  String getQuery();

}
