/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.def;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

/**
 * Define a process record.
 *
 * @author Gael Lalire
 */
public interface ProcessDefinition extends ScopeActivityDefinition {

  /**
   * Returns the UUID for the ProcessDefinition.
   */
  ProcessDefinitionUUID getUUID();

  /**
   * @return name space of the process
   */
  String getNameSpace();

  /**
   *
   * @return the URI of expression language
   */
  String getExpressionLanguage();

  /**
   *
   * @return the URI of query language
   */
  String getQueryLanguage();

  /**
   * @return the date recorded when the definition is deployed
   */
  Date getDeployedDate();

  /**
   * @return the date recorded when the definition is undeployed
   */
  Date getUndeployedDate();

  /**
   * @return the qualified name of the process
   */
  QName getQName();

  /**
   * @return the state of the process
   */
  ProcessState getState();

  /**
   * @return the list of state changes for this process.
   */
  List<ProcessStateUpdate> getStateUpdates();

  /**
   * @return the name of the process resources deployed with the process (BPEL, WSDL, BPMN source files...)
   */
  Collection<String> getProcessResourceNames();

  /**
   * @return the process version.
   */
  int getVersion();
}
