/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.CompletionConditionDefinition;
import org.ow2.orchestra.facade.def.ForeachActivityDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

public class ForeachActivityDefinitionImpl extends BpelActivityWithSingleChildDefinitionImpl
  implements ForeachActivityDefinition {

  private static final long serialVersionUID = 7529197267978015350L;

  private final String finalCounterExpression;

  private final String startCounterExpressionLanguage;

  private final String startCounterExpression;

  private final String finalCounterExpressionLanguage;

  private final boolean parallelValue;

  private final String counterName;

  private final CompletionConditionDefinition completionConditionDefinition;

  public ForeachActivityDefinitionImpl(final ForeachActivityDefinition record) {
    super(record);
    this.counterName = record.getCounterName();
    this.parallelValue = record.isParallel();
    this.finalCounterExpression = record.getFinalCounterExpression();
    this.finalCounterExpressionLanguage = record.getFinalCounterExpressionLanguage();
    this.startCounterExpression = record.getStartCounterExpression();
    this.startCounterExpressionLanguage = record.getStartCounterExpressionLanguage();
    this.completionConditionDefinition = CopyUtil.copy(record.getCompletionConditionDefinition());
  }

  public ActivityType getType() {
    return ActivityType.FOR_EACH;
  }

  public String getFinalCounterExpression() {
    return this.finalCounterExpression;
  }

  public String getFinalCounterExpressionLanguage() {
    return this.finalCounterExpressionLanguage;
  }

  public String getStartCounterExpression() {
    return this.startCounterExpression;
  }

  public String getStartCounterExpressionLanguage() {
    return this.startCounterExpressionLanguage;
  }

  public String getCounterName() {
    return this.counterName;
  }

  public boolean isParallel() {
    return this.parallelValue;
  }

  public CompletionConditionDefinition getCompletionConditionDefinition() {
    return this.completionConditionDefinition;
  }

}
