/**
 * Copyright (C) 2008-2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import java.util.List;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.CorrelationSetInitialization;
import org.ow2.orchestra.facade.runtime.PartnerLinkUpdate;
import org.ow2.orchestra.facade.runtime.ScopeActivityInstance;
import org.ow2.orchestra.facade.runtime.ScopeStateUpdate;
import org.ow2.orchestra.facade.runtime.VariableUpdate;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;

/**
 * @author Alfonso Fuca, S. Ali Tokmen
 */
public class ScopeActivityInstanceImpl extends ActivityWithSingleChildInstanceImpl implements ScopeActivityInstance {

  private static final long serialVersionUID = 5106550190077723993L;

  /** all runtime variables of this scope. */
  protected List<VariableUpdate> variables = null;

  protected List<CorrelationSetInitialization> correlationSet = null;

  protected List<PartnerLinkUpdate> partnerLink = null;

  protected List<ScopeStateUpdate> scopeState = null;

  protected ActivityInstanceUUID faultHandlerActivityUUID = null;

  protected ActivityInstanceUUID terminationHandlerActivityUUID = null;

  protected ActivityInstanceUUID compensationHandlerActivityUUID = null;

  protected List<ActivityInstanceUUID> eventInstanceUUIDs = null;

  public ScopeActivityInstanceImpl(final ScopeActivityInstance record) {
    super(record);
    this.variables = CopyUtil.copyList(record.getVariables());
    this.correlationSet = CopyUtil.copyList(record.getCorrelationSet());
    this.partnerLink = CopyUtil.copyList(record.getPartnerLink());
    this.scopeState = CopyUtil.copyList(record.getScopeState());
    if (record.getFaultHandlerActivityUUID() != null) {
      this.faultHandlerActivityUUID = new ActivityInstanceUUID(record.getFaultHandlerActivityUUID());
    }
    if (record.getTerminationHandlerActivityUUID() != null) {
      this.terminationHandlerActivityUUID = new ActivityInstanceUUID(record.getTerminationHandlerActivityUUID());
    }
    if (record.getCompensationHandlerActivityUUID() != null) {
      this.compensationHandlerActivityUUID = new ActivityInstanceUUID(record.getCompensationHandlerActivityUUID());
    }
    this.eventInstanceUUIDs = CopyUtil.copyList(record.getEventInstanceUUIDs());
  }

  public ActivityType getType() {
    return ActivityType.SCOPE;
  }

  @Override
  public String toString() {
    final String st = this.getClass().getName() + "[uuid: " + this.getUUID()
      + ", processDefinitionUUID: " + this.getProcessDefinitionUUID()
      + ", processUUID: " + this.getProcessInstanceUUID()
      + ", startedDate: " + this.getStartedDate() + ", endedDate: " + this.getEndedDate()
      + ", activityType: " + this.getType() + ", scopeState: " + this.getScopeState() + "]\n";
    return st;
  }

  public List<VariableUpdate> getVariables() {
    return this.variables;
  }

  public List<CorrelationSetInitialization> getCorrelationSet() {
    return this.correlationSet;
  }

  public List<PartnerLinkUpdate> getPartnerLink() {
    return this.partnerLink;
  }

  public List<ScopeStateUpdate> getScopeState() {
    return this.scopeState;
  }

  public ActivityInstanceUUID getFaultHandlerActivityUUID() {
    return this.faultHandlerActivityUUID;
  }

  public ActivityInstanceUUID getTerminationHandlerActivityUUID() {
    return this.terminationHandlerActivityUUID;
  }

  public ActivityInstanceUUID getCompensationHandlerActivityUUID() {
    return this.compensationHandlerActivityUUID;
  }

  public List<ActivityInstanceUUID> getEventInstanceUUIDs() {
    return this.eventInstanceUUIDs;
  }
}
