/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 *
 * @author Gael Lalire
 */
public final class CopyUtil {

  private CopyUtil() {
  }

  public static <E> Set<E> copySet(final Set< ? extends CopyAble<E>> copyAbleSet) {
    if (copyAbleSet == null) {
      return null;
    }
    final HashSet<E> copyAbleSetCopy = new HashSet<E>();
    for (final CopyAble<E> copyAble : copyAbleSet) {
      copyAbleSetCopy.add(copyAble.copy());
    }
    return copyAbleSetCopy;
  }


  public static <E> List<E> copyList(final List< ? extends CopyAble<E>> copyAbleList) {
    if (copyAbleList == null) {
      return null;
    }
    final List<E> copyAbleListCopy = new ArrayList<E>();
    for (final CopyAble<E> copyAble : copyAbleList) {
      copyAbleListCopy.add(copyAble.copy());
    }
    return copyAbleListCopy;
  }

  public static <E> E copy(final CopyAble<E> copyAble) {
    if (copyAble == null) {
      return null;
    }
    return copyAble.copy();
  }


}
